-- CourseContentsList thinks it isn't an ActorScroller,
-- so have to define its transform function separately. Gah!
local transform = function(self,offsetFromCenter,itemIndex,numItems)
	self:x( offsetFromCenter * 120 )
	--[[ First condition is for making sure the items disappear before going past the banner.
	-- Second condition is to make their transition from the bottom of the screen look a little smoother.
	-- The exact numbers will likely need changing if "NumItemsToDraw" is changed.
	if offsetFromCenter < -1 or offsetFromCenter > 5 then
		self:diffusealpha(0)
	-- And this is just so the objects don't look quite as "THERE" underneath the info pane and footer.
	elseif offsetFromCenter < 0 or offsetFromCenter > 4 then
		self:diffusealpha(0.6)
	end
	--]]
end

local t = Def.ActorFrame{
	Def.CourseContentsList {
		MaxSongs = 1000,
		NumItemsToDraw = 8,
		SetCommand=function(self)
			self:stoptweening()
			:SetFromGameState()
			:PositionItems()
			:SetLoop(false)
			:SetPauseCountdownSeconds(0.05)
			:SetSecondsPauseBetweenItems(0)
			:SetTransformFromFunction(transform)
			:SetCurrentAndDestinationItem(1.5)

			local course = GAMESTATE:GetCurrentCourse()
			if course and course:GetEstimatedNumStages() > 4 then
				self:playcommand("ScrollUp")
				self:setsecondsperitem(0.05)
			end
		end;
		ScrollDownCommand = function(self)
			self:finishtweening();
			self:setsecondsperitem(0.9);
			self:SetDestinationItem( self:GetNumChildren()-3 );
			local fTime = self:getsecondtodestination();
			self:sleep(fTime + 0.7);
			self:queuecommand("ScrollUp");
		end;
		ScrollUpCommand = function(self)
			self:finishtweening();
			self:setsecondsperitem(0.2);
			self:SetDestinationItem( 2 );
			local fTime = self:getsecondtodestination();
			self:sleep(fTime + 0.7);
			self:queuecommand("ScrollDown");
		end;
		CurrentTrailP1ChangedMessageCommand=cmd(playcommand,"Set");
		CurrentTrailP2ChangedMessageCommand=cmd(playcommand,"Set");

		Display = Def.ActorFrame { 
			InitCommand=cmd(setsize,200,34),
			
			
			Def.Quad {
				Name = "Frame",
				InitCommand=function(self)
					self:diffuse(LocalBlueColor(1)):zoomto(84,84)
				end
			},
			Def.Sprite {
				Name = "Banner"
			},
			
			Def.Quad {
				Name = "TextBacking",
				InitCommand=function(self)
					self:diffuse(LocalBlueColor(0.5)):vertalign(bottom):y(40):zoomto(80,0):blend(Blend.Modulate)
				end
			},
			
			Def.Quad {
				Name="NumBack",
				InitCommand=function(self)
					self:diffuse(LocalBlueColor(0.5)):horizalign(left):vertalign(top):xy(-40,-40):zoomto(30,20):blend(Blend.Modulate)
				end
			},
			Def.BitmapText {
				Font = "Common Normal",
				Name = "Number",
				InitCommand=function(self) self:xy(-40,-40):horizalign(left):vertalign(top):zoom(0.5):strokecolor(Color.Black) end
			},
			Def.BitmapText {
				Font = "Common Normal",
				Name = "Name",
				InitCommand=function(self) self:y(38):vertalign(bottom):maxwidth(80/0.3):wrapwidthpixels(80/0.3):zoom(0.3):strokecolor(Color.Black) end
			},
			Def.BitmapText {
				Font = "Common Normal",
				Name = "Difficulty_P1",
				InitCommand=cmd(x,-42;y,-40;horizalign,right;vertalign,top;zoom,0.5)
			},
			Def.BitmapText {
				Font = "Common Normal",
				Name = "Difficulty_P2",
				InitCommand=cmd(x,42;y,-40;horizalign,left;vertalign,top;zoom,0.5)
			},
			
			SetSongMessageCommand=function(self, params)
				if params.Song and params.Steps then
					--local songTitle = params.Secret and "??????????" or params.Song:GetDisplayFullTitle()
					local songTitle = params.Song:GetDisplayFullTitle()
					
					self:GetChild("Number"):settext("#" .. params.Number)
					self:GetChild("Name"):settext(songTitle)
					-- Need to disable "ztest" while loading, lest the fake-cropped banners start overlapping
					self:GetChild("Banner"):LoadBanner(params.Song:GetJacketOrSubstitutePath())
					self:GetChild("Banner"):scaletoclipped(80,80)
					--diffuse(params.Secret and color("#111111") or Color.White)
					
					for pn in ivalues(GAMESTATE:GetEnabledPlayers()) do
						if params.PlayerNumber == pn then
							self:GetChild("Difficulty_" .. ToEnumShortString(pn)):player(pn):settext(params.Steps:GetMeter()):DifficultyColoring(CustomDifficultyToColor(params.Difficulty), params.Steps:IsAutogen())
						end
					end
				else
					self:GetChild("NumberAndName"):settext("??????????")
					self:GetChild("Banner"):Load(nil)
				end
				self:GetChild("TextBacking"):zoomy((self:GetChild("Name"):GetHeight() * 0.3) + 4)
			end
		}
	},
	
	-- Probably the worst way I could have done this;
	-- stepsdisplay... for courses!
	Def.ActorFrame{
		Name = "Trails_P1",
		InitCommand=function(self) self:x(-_screen.cx) end,
		Def.Quad{
			OnCommand=function(self)
				self:horizalign(left):zoomto(40,92):diffuse(Color.Black)
			end,
		},
		Def.Quad{
			Name = "Easy",
			OnCommand=function(self)
				self:xy(15,-30):zoomto(20,20):diffuse(GameColor.Difficulty.Medium)
			end,
		},
		Def.Quad{
			Name = "Medium",
			OnCommand=function(self)
				self:x(15):zoomto(20,20):diffuse(GameColor.Difficulty.Hard)
			end,
		},
		Def.Quad{
			Name = "Hard",
			OnCommand=function(self)
				self:xy(15,30):zoomto(20,20):diffuse(GameColor.Difficulty.Challenge)
			end,
		},
	},
	Def.ActorFrame{
		Name = "Trails_P2",
		InitCommand=function(self) self:x(_screen.cx) end,
		Def.Quad{
			OnCommand=function(self)
				self:horizalign(right):zoomto(40,92):diffuse(Color.Black)
			end,
		},
		Def.Quad{
			Name = "Easy",
			OnCommand=function(self)
				self:xy(-15,-30):zoomto(20,20):diffuse(GameColor.Difficulty.Medium)
			end,
		},
		Def.Quad{
			Name = "Medium",
			OnCommand=function(self)
				self:x(-15):zoomto(20,20):diffuse(GameColor.Difficulty.Hard)
			end,
		},
		Def.Quad{
			Name = "Hard",
			OnCommand=function(self)
				self:xy(-15,30):zoomto(20,20):diffuse(GameColor.Difficulty.Challenge)
			end,
		},
	},
}

return t